# h:/fips/scripts/autodnld/autodnld_get_dir.pl


# NOTE: use of LWP module is experimental
# If you want to use it, uncomment the line "use LWP::UserAgent"
# There are references to LWP modules in the following Perl code, but as long as you
# don't call the DownloadFileViaLWP() routine, the code will run fine.

#use LWP::UserAgent;   # <<<<<<<<< uncomment if you want to use LWP

# use strict

use vars ( qw (
               $com_spec
               $slash
               %hIniFile
               %hCrntEnv
               $ftp_server_password
               ));


# capture ftp.exe input and output lines for debug; if empty, not using ftp.exe
use vars ( qw ( @aFtpInLine @aFtpOutLine  ));

# GetRemoteDirPasvFtp
# GetRemoteDirFtp
# XlatHtmlToDirListingVer1
# XlatHtmlToDirListingVer2
# XlatHtmlToDirListingVer3
# XlatHtmlToDirListingVer4
# XlatHtmlToDirListingVer5
# GetRemoteDirViaLWP
# GetRemoteDir   <<< ENTRY
# VerifyRemoteDir


# --------------------------------- GetRemoteDirPasvFtp

sub GetRemoteDirPasvFtp
{
my (
    
    $szVerbose,      #share Verbose flag as DownloadFileViaPasvFtp, passed by $hIniFile{pasv_ftp}, or if defined as 1, will run with minimum debug level.
    $szPasvFlag, #this flag will enable either passive or active ftp
    $subdir,  # dir that you want dir on
                                # always start with slash plus user name, and end with slash plus dot
                                # examples:
                                #      /xmaspool/distribution/.
                                #      /xmaspool/../pooldata/shipping/.

    $paDir,           # return to caller: data lines only; filter out status lines for example; no CR/LF junk on end
                      # we expect tokens to be in certain locations as follows
                      #     0=permissions
                      #     1=?
                      #     2=user
                      #     3=group
                      #     4,5,6,7=stamp
                      #     8=fn
                      # example:
                      #    0             1 2        3                  4  5   6  7     8
                      #    '----------   1 owner    group              39 Apr 26 11:17 tedh.inf'
                      #    'd---------   1 owner    group               0 Jan 14  2000 cmo_cdi'

    $paErr,        # if error, put push msg(s) here
    $bFilesNotNeeded
    ) = @_;

my ( $msg );
my @aTraceBack = ( "subdir=$subdir" );

AppendLog ( "GetRemoteDirPasvFtp: start; dir=$subdir" );

# must have exe
my ( $exe ) = "$hIniFile{'autodnld_home'}$slash" . "scripts$slash$hIniFile{pasv_ftp}";

if ( ! ( -e $exe ))
    {
    # want user-friendly message(s), followed by traceback
    push ( @$paErr, "Unable to get dir listing on Intex server" );
    push ( @aTraceBack, "unable to find exe=$exe" );
    push ( @$paErr, "", "Traceback:", @aTraceBack );
    return;
    }

# compose command and run it
my ( $out ) = "$hCrntEnv{'tgt_log_dir'}$slash" . "pasv_ftp.log";
my ( $cmd ) = "$exe $hIniFile{connection} $hIniFile{user} $ftp_server_password $out -dir $subdir";  # global
AppendLog ( "GetRemoteDirPasvFtp: cmd=$cmd" );
system ( $cmd );

if ( $? && $bFilesNotNeeded == 2 )
    {
    # want user-friendly message(s), followed by traceback
    AppendLog ( "GetRemoteDirPasvFtp: error with passive ftp, but bFilesNotNeeded=2, so is OK and will continue." );
    }
elsif ( $? )
    {
    # want user-friendly message(s), followed by traceback
    push ( @$paErr, "Unable to get dir listing on Intex server" );
    push ( @aTraceBack, "error code returned by exe=$exe" );
    push ( @$paErr, "", "Traceback:", @aTraceBack );
    return;
    }

# put the output in list
open ( PASV_FTP_OUT, $out );
my ( @aLine ) = <PASV_FTP_OUT>;
close ( PASV_FTP_OUT );
chomp ( @aLine );
push ( @$paDir, @aLine );

# to help debug...
AppendLog ( "GetRemoteDirPasvFtp(): dir lines returned by exe\n--------\n" . join("\n",@aLine) . "\n---------" ) if ( $hIniFile{user} eq 'aacc' );

return ();

} # GetRemoteDirPasvFtp



# ------------------------- GetRemoteDirFtp
# ftp into ship server, get a dir listing using the ftp program

# called by
#    CheckAccessToFtpServer

######### sample lines ... often we can use a numeric code starting in column 1
# No connection (NT): Not connected.
# login failed: "530 ...
# cd command: "250 CWD command successful."
# header line just before ls output: "150...
# data line: "-rwxrwxrwx   1 owner    group             382 Oct 11 11:32 shipinfo.zip"
# footer line just after ls output ... but don't check for this!: "226 ASCII Transfer complete"  ... but don't check for this code!

sub GetRemoteDirFtp
{
my (
    $subdir,  # dir that you want dir on
                  # always start with slash plus user name, and end with slash plus dot
                  # examples:
                  #      /xmaspool/distribution/.
                  #      /xmaspool/../pooldata/shipping/.

    $paDataLine,     # return to caller: data lines only; filter out status lines for example; no CR/LF junk on end
                            # we expect tokens to be in certain locations as follows
                            #     0=permissions
                            #     1=?
                            #     2=user
                            #     3=group
                            #     4=size
                            #     5,6,7=stamp
                            #     8=fn
                            # example:
                            #    0             1 2        3                  4  5   6  7     8
                            #    '----------   1 owner    group              39 Apr 26 11:17 tedh.inf'
                            #    'd---------   1 owner    group               0 Jan 14  2000 cmo_cdi'

    $paErr,        # if error, push msg(s) here
    $bFilesNotNeeded,
    ) = @_;

my @aTraceBack = ();
my ( $iUsingNcftp ) = ( $hIniFile{'ftp_cmd'} =~ /ncftp/ ) ? 1 : 0;

FixSlashes ( \$subdir, "unix" );
push ( @aTraceBack, "subdir=$subdir" );  # junky
AppendLog( "GetRemoteDirFtp(): start: subdir=$subdir" );

# create ftp command file
my @aftpLines = ();
BuildFtpSessionHeader ( \@aftpLines );

if($subdir ne "")
    {
    push(@aftpLines,"cd $subdir");
    }

push(@aftpLines,"ls -l");
push(@aftpLines,"bye");

# run the ftp command; capture output to disk file; return any errors in a list
# We always update two globals: @aFtpInLine and @aFtpOutLine
my ( @aRunFtpErr) = RunFtp( @aftpLines);

if ( scalar(@aRunFtpErr) )
    {
    my @aMsg =
        (
         "Unable to get dir listing on Intex server.Try to manually run FTP using the commands being passed to ftp program as shown below to determine the cause of the error.", 
         "Debug information from RunFtp():",
         @aRunFtpErr,
         "More debug information:",
         compose_lines_from_ftp_in_out_lines(),
         );

    push ( @$paErr, @aMsg );
    return;
    }

# scan lines of ftp output (UNIX format always); pick out file info line only; use state machine


## 200 PORT command successful.
## 150 Opening ASCII mode data connection for /bin/ls.
## ----------   1 owner    group              39 Nov  3  2001 cigna.inf
## d---------   1 owner    group               0 Sep 20  2001 cmo_cdi
## d---------   1 owner    group               0 May  2 20:24 distrib
## d---------   1 owner    group               0 Sep 23  2001 test      <<<<<<<<<< this may be the end of the listing
## 226 Transfer complete.
## ftp: 271 bytes received in 0.02Seconds 13.55Kbytes/sec.

## 250 CWD command successful.

## 200 PORT command successful.
## 150 Opening ASCII mode data connection for /bin/ls.
## ----------   1 owner    group          741566 May  2 20:23 cmo_cdi.000132.zip
## ----------   1 owner    group         9883665 May  2 20:24 cmo_cdu.000132.zip
## ----------   1 owner    group              30 May  2 20:24 eot.000132.txt
## d---------   1 owner    group               0 May  2 20:24 last
## d---------   1 owner    group               0 May  2 20:24 last2
## d---------   1 owner    group               0 May  2 20:24 last3
## d---------   1 owner    group               0 May  2 20:24 last4
## ----------   1 owner    group            1280 May  2 20:24 shipinfo.000132.zip   <<<<<<<<<< this may be the end of the listing
## 226 Transfer complete.

my @aDirDataLine = ();   # build up info here
my $found_cd_code_250 = 0;

my @aListOfFiveCauses =
    (
     "1) Problem connecting from the autodnld machine to your firewall",
     "2) Firewall machine not allowing FTP access to Intex server",
     "3) Intex server not online",
     "4) Your IP address has changed",
     "5) Incorrect password provided to the ship server",
     "To test connection try manually ftp'ing to ship server",
     "Also see if any changes made to your firewall",
     );

##print "
## GetRemoteDirFtp(): aFtpOutLine:
##---------------------------- start
##" . join("\n",@aFtpOutLine) . "
##-------------------------- end\n";


foreach my $line (@aFtpOutLine) # global
    {
    # if using ncftp, just pattern match on owner...group
    if ( $iUsingNcftp )
        {
        if ( $line =~ /owner\s+group/ )
            {
            push ( @aDirDataLine, $line );
            }
        next;
        }

    # if code 200 and/or 150 and/or, this is normal; skip
    if ( $line =~ /^200 /  ||  $line =~ /^150/  ||  $line =~ /connected/i )
        {
        next;
        }

    # if code=250 (change subdir), take note
    if ( $line =~ /^250 / )
        {
        $found_cd_code_250 = 1;
        next;
        }

    # connection failed? (message with unix ftp client=???)
    if ( lc($line) =~ /not connected/i )
        {
        my @aMsg = ();
        push ( @aMsg, "Could saw a \"not connected\" error message when trying to access the Intex server" );
        push ( @aMsg, "" );
        push ( @aMsg, "Possible causes:" );
        push ( @aMsg, @aListOfFiveCauses );
        push ( @aMsg, "" );
        push ( @aMsg, "FTP session debug information:", compose_lines_from_ftp_in_out_lines() );
        AppendLog( "GetRemoteDirFtp(): return error lines:\n" . join("\n",@aMsg), "", \@aMsg );
        push ( @$paErr, @aMsg );
        return;
        }

    # got this far: accept the line if token count is OK
    my @aToken = split ( /\s+/, $line );

    if ( scalar(@aToken) != 9 )
        {
        next;
        }

    # got this far, must still be in middle of dir listing, save the line
    push ( @aDirDataLine, $line );
    }

# ok, we have parsed the directory listing
# if running ncftp, no control codes, so try our best to catch errors
if ( $iUsingNcftp )
    {
    if ( scalar ( @aDirDataLine ) )
        {
        $paDataLine = \@aDirDataLine;
        return ();
        }
    else
        {
        # want user-friendly message(s), followed by traceback
        my @aMsg = ();
        push ( @aMsg, "We did not see any files listed on the Intex server" );
        push ( @aMsg, "(We are using ncftp)" );
        push ( @aMsg, "" );
        push ( @aMsg, "Possible causes:" );
        push ( @aMsg, @aListOfFiveCauses );
        push ( @aMsg, "" );
        push ( @aMsg, "FTP session debug information:", compose_lines_from_ftp_in_out_lines() );
        AppendLog( "GetRemoteDirFtp(): return error lines:\n" . join("\n",@aMsg),"", \@aMsg );
        push ( @$paErr, @aMsg );
        return;
        }
    }

# ok, not ncftp...onwards
if ( scalar ( @aDirDataLine ) == 0 && defined ( $bFilesNotNeeded ) && $bFilesNotNeeded == 2 )
    {
    AppendLog ( "GetRemoteDirFtp(): Did not find any files...is expected by bFilesNotNeeded=$bFilesNotNeeded usually means this is an id shipment and eot file not in dir" ) ;
    }
elsif ( $subdir =~ /last\d{0,2}/ && scalar ( @aDirDataLine ) == 0 )
    {
    AppendLog( "GetRemoteDirFtp(): no dir lines found, but error suppressed due it being a last directory, so might not exist." );
    }
elsif (( scalar ( @aDirDataLine ) == 0 )&&($subdir !~/last\d{0,2}\/\.$/)) # There is possibility that we may a empty dir list in one of the last folder.
    {
    my @aMsg = ();
    push ( @aMsg, "We did not see any files listed on the Intex server" );
    push ( @aMsg, "" );
    push ( @aMsg, "Possible causes:" );
    push ( @aMsg, @aListOfFiveCauses );
    push ( @aMsg, "" );
    push ( @aMsg, "FTP session debug information:", compose_lines_from_ftp_in_out_lines() );
    AppendLog( "GetRemoteDirFtp(): return error lines:\n" . join("\n",@aMsg), "", \@aMsg ) if ( ! $bFilesNotNeeded  ) ;
    push ( @$paErr, @aMsg );
    return;
    }

# have lines, but another possible error check: if cd command, did it work?
# may fail if we are looking for the pooldata subdir etc
if ( $subdir ne "" && $found_cd_code_250 == 0 )
    {
    if  (defined($hIniFile{no_chdir_code_250})  )
        {
        AppendLog( "GetRemoteDirFtp(): no code 250 found, but error suppressed due to ini file setting: no_chdir_code_250" );
        }
    elsif  (  $subdir =~ /last\d{0,2}/ )
        {
        AppendLog( "GetRemoteDirFtp(): no code 250 found, but error suppressed due it being a last directory, so might not exist." );
        }
    else
        {
        my @aMsg = ();
        push ( @aMsg, "We were unable to change subdirectories on the Intex server" );
        push ( @aMsg, "" );
        push ( @aMsg, "Possible causes:" );
        push ( @aMsg, @aListOfFiveCauses );
        push ( @aMsg, "" );
        push ( @aMsg, "FTP session debug information:", compose_lines_from_ftp_in_out_lines() );
        AppendLog( "GetRemoteDirFtp(): return error lines:\n" . join("\n",@aMsg), "", \@aMsg );
        push ( @$paErr, @aMsg );
        return;
        }
    }

# all is OK
# pass array back via ref
AppendLog( "GetRemoteDirFtp(): we are done and all is OK" );
push ( @$paDataLine,@aDirDataLine );

} # GetRemoteDirFtp
# ------------------------- MoveEotFtp
sub MoveEotFtp
{
my (
    $szSourceFile,
    $szDestFile,
    $paDataLine,
    $paErr,
    $bFilesNotNeeded,
    ) = @_;

my @aTraceBack = ();
my ( $iUsingNcftp ) = ( $hIniFile{'ftp_cmd'} =~ /ncftp/ ) ? 1 : 0;
my $szThisFn = "MoveEotFtp" ;

FixSlashes ( \$szSourceFile, "unix" );
FixSlashes ( \$szDestFile,   "unix" );
push ( @aTraceBack, "source_file=$szSourceFile" );  # junky
AppendLog( "$szThisFn: start: move $szSourceFile to $szDestFile" );

# create ftp command file
my @aftpLines = ();
BuildFtpSessionHeader ( \@aftpLines );

push(@aftpLines,"rename $szSourceFile $szDestFile");
push(@aftpLines,"bye");

# run the ftp command; capture output to disk file; return any errors in a list
# We always update two globals: @aFtpInLine and @aFtpOutLine
my ( @aRunFtpErr) = RunFtp( @aftpLines);

if ( scalar(@aRunFtpErr) )
    {
    my @aMsg =
        (
         "Unable to move $szSourceFile to $szDestFile",
         "Debug information from RunFtp():",
         @aRunFtpErr,
         "More debug information:",
         compose_lines_from_ftp_in_out_lines(),
         );

    push ( @$paErr, @aMsg );
    return;
    }

} # MoveEotFtp



sub MoveEotSecureFX
{
my (
    $szSourceFile,
    $szDestFile,
    $paDataLine,
    $paErr,
    $bFilesNotNeeded,
    ) = @_;

my @aTraceBack = ();
my ( $iUsingNcftp ) = ( $hIniFile{'ftp_cmd'} =~ /ncftp/ ) ? 1 : 0;
my $szThisFn = "MoveEotFtpSecureFX" ;

my $szUser = $hIniFile{'user'} ;
$szSourceFile =~ s/^[\\\/]?$szUser// ;
$szDestFile = "..\\" . $szDestFile ;

FixSlashes ( \$szSourceFile, "unix" );
FixSlashes ( \$szDestFile,   "unix" );
#$szSourceFile =~ s/\.$//g ;
#$szDestFile =~ s/\.$//g ;


push ( @aTraceBack, "source_file=$szSourceFile" );  # junky
AppendLog( "$szThisFn: start: move $szSourceFile to $szDestFile" );

my $szCmd ;
if ( $hIniFile{'securefx_exe'} )
   {
   my $szSecureFxExe = $hIniFile{'securefx_exe'} ;
   $szCmd = "$com_spec $szSecureFxExe \/Rename ftp:\/\/".$hIniFile{'user'}.":".$ftp_server_password."\@".$hIniFile{'connection'}."$szSourceFile $szDestFile > $::szFtpOut" ;
   }
else
   {
   $szCmd = "$com_spec sfxcl.EXE \/Rename ftp:\/\/".$hIniFile{'user'}.":".$ftp_server_password."\@".$hIniFile{'connection'}."$szSourceFile $szDestFile > $::szFtpOut" ;
   }

AppendLog( "$szThisFn(): start: $szCmd" );

system ( $szCmd ) ;


} # MoveEotFtpSecureFX

# ------------------------- MoveEotPassiveFtp ## pasv_ftp.exe ftp.intex.com intexnet XXX.XXX dir.txt -rename /distrib/id/processed/old.txt  /distrib/id/processed/new.txt

sub MoveEotPassiveFtp
{
my (
    $szSourceFile,
    $szDestFile,
    $paDataLine,
    $paErr,
    $bFilesNotNeeded,
    ) = @_;

my @aTraceBack = ();
my ( $iUsingNcftp ) = ( $hIniFile{'ftp_cmd'} =~ /ncftp/ ) ? 1 : 0;
my $szThisFn = "MoveEotPassiveFtp" ;

my $szUser = $hIniFile{'user'} ;

#$szSourceFile =~ s/^[\\\/]?$szUser// ;
#$szDestFile = "..\\" . $szDestFile ;

FixSlashes ( \$szSourceFile, "unix" );
FixSlashes ( \$szDestFile,   "unix" );
#$szSourceFile =~ s/\.$//g ;
#$szDestFile =~ s/\.$//g ;


push ( @aTraceBack, "source_file=$szSourceFile" );  # junky
AppendLog( "$szThisFn: start: move $szSourceFile to $szDestFile" );
my ( $out ) = "$hCrntEnv{'tgt_log_dir'}$slash" . "pasv_ftp.log";  # junk file

my $szCmd ;
my $szExe = "$hIniFile{'autodnld_home'}$slash" . "scripts$slash$hIniFile{pasv_ftp}" ;
$szCmd = "$com_spec $szExe $hIniFile{connection} $hIniFile{user} $ftp_server_password -rename $szSourceFile $szDestFile > $out" ;

AppendLog( "$szThisFn(): start: $szCmd" );

system ( $szCmd ) ;


} # MoveEotPassiveFtp


# --------------------- XlatHtmlToDirListingVer1
# use this parser for ???

# incoming lines:
# --------------
##   Client-Date: Mon, 13 Aug 2001 11:49:11 GMT
##
##   ----------   1 owner    group              39 Apr 26 11:17 cigna.inf

# autodnld expects this layout for dir listings:
#     0=permissions
#     1=?
#     2=user
#     3=group
#     4=size
#     5,6,7=stamp
#     8=fn
# examples:
#    0             1 2        3                  4  5   6  7     8
#    '----------   1 owner    group              39 Apr 26 11:17 tedh.inf'
#    'd---------   1 owner    group               0 Jan 14  2000 cmo_cdi'


# return list of dir lines

sub XlatHtmlToDirListingVer1
{
my (
    $paRaw,    # raw listing w/ crlf already removed
    ) = @_;

# trivial translation
my @aDir = grep(/owner\s+group/, @$paRaw);

AppendLog ( "XlatHtmlToDirListingVer1(): after parsing the output, here is the reconstructed dir listing:
===============================
" . join("\n",@aDir) . "
===============================" );

} # XlatHtmlToDirListingVer1


# --------------------- XlatHtmlToDirListingVer2
# for the "winproxy" proxy server, this algorithm works

# autodnld expects this layout for dir listings:
#     0=permissions
#     1=?
#     2=user
#     3=group
#     4=size
#     5,6,7=stamp
#     8=fn
# examples:
#    0             1 2        3                  4  5   6  7     8
#    '----------   1 owner    group              39 Apr 26 11:17 tedh.inf'
#    'd---------   1 owner    group               0 Jan 14  2000 cmo_cdi'

# return list of dir lines

sub XlatHtmlToDirListingVer2
{
my (
    $paRaw,    # raw listing w/ crlf already removed
    ) = @_;

AppendLog ( "XlatHtmlToDirListingVer2: start" );

# scan lines, looking for files, directories etc
my @aDir = ();

foreach my $line ( @$paRaw )
{
    my @aToken = split( /\s+/, $line );

    # directory line? ... e.g. '<A HREF="last2"><B>last2</B></A> Dec 11 2001 19:12 Directory'
    if ( $aToken[-1] eq 'Directory' )
        {
        $line =~ /"(.+)"/;
        my $subdir = $1;
        my $stamp = "$aToken[-5] $aToken[-4] $aToken[-2]";  # e.g. 'Dec 11 19:12'
        #
        #                   0     1   2     3   4  5,6,7
        push ( @aDir, "d--------- 1 owner group 0 $stamp $subdir" );
        }

    #                                                                          -7  -6 -5  -4    -3    -2   -1
    # file line? ... e.g. '<A HREF="eot.000014.txt"><B>eot.000014.txt</B></A>  30 Dec 11 2001 19:12 Plain Text'
    # this is fragile, but we are going to look for "Compressed Data" or "Plain Text"
    next if ( $line !~ /Compressed Data/ && $line !~ /Plain Text/ );
    $line =~ /"(.+)"/;
    my $file = $1;
    my $sze = $aToken[-7];
    $sze =~ s/,//g;
    my $stamp = "$aToken[-6] $aToken[-5] $aToken[-3]";  # e.g. 'Dec 11 19:12'
    push ( @aDir, "---------- 1 owner group $sze $stamp $file" );
}

AppendLog ( "XlatHtmlToDirListingVer2(): after parsing the output, here is the reconstructed dir listing:
===============================
" . join("\n",@aDir) . "
===============================" );

return @aDir;

} # XlatHtmlToDirListingVer2


#-------------------------------  XlatHtmlToDirListingVer3
sub XlatHtmlToDirListingVer3
{
my (
    $paRaw,    # raw listing w/ crlf already removed
    ) = @_;

my $func = "XlatHtmlToDirListingVer3";
AppendLog ( "$func: start" );

# scan lines, looking for files, directories etc
my @aDir = ();

foreach my $line ( @$paRaw )
{
    my @aToken = split( /\s+/, $line );

    # directory line? ... last token is 'Directory' e.g. '<A HREF="last2"><B>last2</B></A> Dec 11 2001 19:12 Directory'
    #                                                                     -5  -4 -3   -2    -1
    # <A HREF="last"><B>last</B></A>                                      Sep 04 2002 16:53 Directory
    if ( defined($aToken[-1])  &&  $aToken[-1] eq 'Directory' )
        {
        AppendLog ( "$func: subdir line=$line" );

        # pick out subdir name; easy: inside quotes
        $line =~ /"(.+)"/;
        my $subdir = $1;

        # for the stamp, work backwards thru line
        my $stamp = "$aToken[-5] $aToken[-4] $aToken[-3]";

        # save in autodnld-ls format
        ## autodnld expects this layout for dir listings:
        ##     0=permissions
        ##     1=?
        ##     2=user
        ##     3=group
        ##     4=size
        ##     5,6,7=stamp ... Apr 26 11:17 .... Jan 14  2000
        ##     8=fn
        #                   0     1   2     3   4  5,6,7
        push ( @aDir, "d--------- 1 owner group 0 $stamp $subdir" );
        next;
        }

    # file line? ... must have this: A HREF= .. .but skip ".." line
    next if ( $line !~ /A HREF=/ );
    next if ( $line =~ /\.\./ );
    AppendLog ( "$func: file line=$line" );


    # we may have trailing phrase like "Compressed Data" or "Plain Text" ... must zap it
    $line =~ s/[A-Za-z\s]+$//;
    AppendLog ( "$func: file line after right-trim=$line" );

    # ok, we have a line of interest
    #                                                                             -5      -4  -3 -2   -1
    # <A HREF="cmo_cdi.000093.tar.Z"><B>cmo_cdi.000093.tar.Z</B></A>              282,861 Sep 04 2002 16:53
    @aToken = split( /\s+/, $line );

    # we can pick out the filename between double quotes
    $line =~ /"(.+)"/;
    my $file = $1;

    # pick out size working backwards thru line
    my $sze = $aToken[-5];
    $sze =~ s/,//g;

    # pick out stamp working backwards thru line
    my $stamp = "$aToken[-4] $aToken[-3] $aToken[-2]";  # e.g. 'Dec 11 19:12'

    # save in autodnld-ls format
    ## autodnld expects this layout for dir listings:
    ##     0=permissions
    ##     1=?
    ##     2=user
    ##     3=group
    ##     4=size
    ##     5,6,7=stamp ... Apr 26 11:17 .... Jan 14  2000
    ##     8=fn
    #                   0     1   2     3   4    5,6,7  8
    push ( @aDir, "---------- 1 owner group $sze $stamp $file" );
}

AppendLog ( "XlatHtmlToDirListingVer3(): after parsing the output, here is the reconstructed dir listing:
===============================
" . join("\n",@aDir) . "
===============================" );

return @aDir;

} # XlatHtmlToDirListingVer3

#-------------------------------  XlatHtmlToDirListingVer4
sub XlatHtmlToDirListingVer4
{
my (
    $paRaw,    # raw listing w/ crlf already removed
    ) = @_;

my $func = "XlatHtmlToDirListingVer4";
AppendLog ( "$func: start" );

# scan lines, looking for files, directories etc
my @aDir = ();

foreach my $line ( @$paRaw )
{
    my @aToken = split( /\s+/, $line );
    AppendLog ( "$func: here is a incoming line: $line" );

    # directory line? ... last token is 'Directory' e.g. '<A HREF="last2"><B>last2</B></A> Dec 11 2001 19:12 Directory'
    #                                                                     -5  -4 -3   -2    -1
    # <A HREF="last"><B>last</B></A>                                      Sep 04 2002 16:53 Directory
    if ( defined($aToken[-1])  &&  $aToken[-1] eq 'Directory' )
        {
        AppendLog ( "$func: subdir line=$line" );

        # pick out subdir name; easy: inside quotes
        $line =~ /"(.+)"/;
        my $subdir = $1;
        if ( $subdir =~ /[\\\/]$/ )
            {
            $subdir =~ s/[\\\/]$// ;
            AppendLog ( "$func: subdir removed trailing slash subdir=$subdir" );
            }

        # for the stamp, work backwards thru line
        my $stamp = "$aToken[-5] $aToken[-4] $aToken[-3]";

        # save in autodnld-ls format
        ## autodnld expects this layout for dir listings:
        ##     0=permissions
        ##     1=?
        ##     2=user
        ##     3=group
        ##     4=size
        ##     5,6,7=stamp ... Apr 26 11:17 .... Jan 14  2000
        ##     8=fn
        #                   0     1   2     3   4  5,6,7
        push ( @aDir, "d--------- 1 owner group 0 $stamp $subdir" );
        AppendLog ( "$func: here is the subdir line as parsed: d--------- 1 owner group 0 $stamp $subdir" );
        next;
        }

    # got this far (already picked off dir lines) ... file line?; must have this: A HREF; but watch out for parent subdir
    # e.g. =<A HREF="cmo_cdu.000187.tar.Z">cmo_cdu.000187.tar.Z</A>..................... Jan 21 2003 16:43         13174508
    next if ( $line !~ /A HREF=/i );
    next if ( $line =~ /parent/i );
    AppendLog ( "$func: file line=$line" );

    # we may have trailing phrase like "Compressed Data" or "Plain Text" ... must zap it
    $line =~ s/[A-Za-z\s]+$//;
    AppendLog ( "$func: file line after right-trim=$line" );

    # ok, we have a line of interest
    #                                                                             -5      -4  -3 -2   -1
    # <A HREF="cmo_cdi.000093.tar.Z"><B>cmo_cdi.000093.tar.Z</B></A>              282,861 Sep 04 2002 16:53
    @aToken = split( /\s+/, $line );

    # we can pick out the filename between double quotes
    $line =~ /"(.+)"/;
    my $file = $1;
    if ( $file =~ /[\\\/]$/ )
       {
       $file =~ s/[\\\/]$// ;
       AppendLog ( "$func: file removed trailing slash file=$file" );
       }

    # pick out size working backwards thru line
    my $sze = $aToken[-1];
    $sze =~ s/,//g;

    # pick out stamp working backwards thru line
    # raw ftp looks like this: Jan 22 16:36
    # this proxy server does this: "...Jan 21 2003 16:43         13174508"
    my $stamp = "$aToken[-5] $aToken[-4] $aToken[-2]";  # e.g. 'Jan 21 16:43'

    # save in autodnld-ls format
    ## autodnld expects this layout for dir listings:
    ##     0=permissions
    ##     1=?
    ##     2=user
    ##     3=group
    ##     4=size
    ##     5,6,7=stamp ... Apr 26 11:17 .... Jan 14  2000
    ##     8=fn
    #                   0     1   2     3   4    5,6,7  8
    push ( @aDir, "---------- 1 owner group $sze $stamp $file" );
    AppendLog ( "$func: here is the file line as parsed: ---------- 1 owner group $sze $stamp $file" );
}

AppendLog ( "XlatHtmlToDirListingVer4(): after parsing the output, here is the reconstructed dir listing:
===============================
" . join("\n",@aDir) . "
===============================" );

return @aDir;

} # XlatHtmlToDirListingVer4

sub XlatHtmlToDirListingVer5
{
my (
    $paRaw,    # raw listing w/ crlf already removed
    ) = @_;

my $func = "XlatHtmlToDirListingVer4";
AppendLog ( "$func: start" );

# scan lines, looking for files, directories etc
my @aDir = ();

foreach my $line ( @$paRaw )
{
next if ( $line =~ /parent directory/i );
    my @aToken = split( /\s+/, $line );
    AppendLog ( "$func: here is a incoming line: $line" );

    # directory line? ... last token is 'Directory' e.g. '<A HREF="last2"><B>last2</B></A> Dec 11 2001 19:12 Directory'
    #                                                                     -5  -4 -3   -2    -1
    # <A HREF="last"><B>last</B></A>                                      Sep 04 2002 16:53 Directory
    if ( defined($aToken[0])  &&  $aToken[0] =~  /DIRECTORY/ )
        {
        AppendLog ( "$func: subdir line=$line" );

        # pick out subdir name; easy: inside quotes
        $line =~ /"(.+)"/;
        my $subdir = $1;
        if ( $subdir =~ /[\\\/]$/ )
            {
            $subdir =~ s/[\\\/]$// ;
            AppendLog ( "$func: subdir removed trailing slash subdir=$subdir" );
            }

        # for the stamp, work backwards thru line
        my $stamp = "$aToken[-3] $aToken[-2] $aToken[-1]";
        $stamp =~ s/[\]\[]//g ;   ## gets rid of "[" or "]"

        # save in autodnld-ls format
        ## autodnld expects this layout for dir listings:
        ##     0=permissions
        ##     1=?
        ##     2=user
        ##     3=group
        ##     4=size
        ##     5,6,7=stamp ... Apr 26 11:17 .... Jan 14  2000
        ##     8=fn
        #                   0     1   2     3   4  5,6,7
        push ( @aDir, "d--------- 1 owner group 0 $stamp $subdir" );
        AppendLog ( "$func: here is the subdir line as parsed: d--------- 1 owner group 0 $stamp $subdir" );
        next;
        }

    # got this far (already picked off dir lines) ... file line?; must have this: A HREF; but watch out for parent subdir
    # e.g. =<A HREF="cmo_cdu.000187.tar.Z">cmo_cdu.000187.tar.Z</A>..................... Jan 21 2003 16:43         13174508
    next if ( $line !~ /A HREF=/i );
#    next if ( $line !~ /FILE|BINARY/i );
    next if ( $line =~ /parent/i );
### "[FILE]       <A HREF="wamu_capital_corp.inf">wamu_capital_corp.inf</A>.. . . . . . . . .    [Jul  2  2002]      7B ",
    AppendLog ( "$func: file line=$line" );

    # we may have trailing phrase like "Compressed Data" or "Plain Text" ... must zap it
    $line =~ s/[A-Za-z\s]+$//;
    AppendLog ( "$func: file line after right-trim=$line" );

    # ok, we have a line of interest
    #                                                                             -5      -4  -3 -2   -1
### "[FILE]       <A HREF="wamu_capital_corp.inf">wamu_capital_corp.inf</A>.. . . . . . . . .    [Jul  2  2002]      7",
    @aToken = split( /\s+/, $line );

    # we can pick out the filename between double quotes
    $line =~ /"(.+)"/;
    my $file = $1;
    if ( $file =~ /[\\\/]$/ )
       {
       $file =~ s/[\\\/]$// ;
       AppendLog ( "$func: file removed trailing slash file=$file" );
       }

    # pick out size working backwards thru line
    my $sze = $aToken[-1];
    $sze =~ s/,//g;

    # pick out stamp working backwards thru line
    # raw ftp looks like this: Jan 22 16:36
    # this proxy server does this: "...Jan 21 2003 16:43         13174508"
    my $stamp = "$aToken[-4] $aToken[-3] $aToken[-2]";  # e.g. 'Jan 21 16:43'
    $stamp =~  s/[\[\]]//g ;  #

    # save in autodnld-ls format
    ## autodnld expects this layout for dir listings:
    ##     0=permissions
    ##     1=?
    ##     2=user
    ##     3=group
    ##     4=size
    ##     5,6,7=stamp ... Apr 26 11:17 .... Jan 14  2000
    ##     8=fn
    #                   0     1   2     3   4    5,6,7  8
    push ( @aDir, "---------- 1 owner group $sze $stamp $file" );
    AppendLog ( "$func: here is the file line as parsed: ---------- 1 owner group $sze $stamp $file" );
}

AppendLog ( "XlatHtmlToDirListingVer4(): after parsing the output, here is the reconstructed dir listing:
===============================
" . join("\n",@aDir) . "
===============================" );

print  join("\n",@aDir) ;
return @aDir;

} # XlatHtmlToDirListingVer5

# --------------------------------- GetRemoteDirViaLWP
# return () if no errors; else, has errors for tech users  # debug hint: b postpone GetRemoteDirViaLWP
sub GetRemoteDirViaLWP
{
my (
    $subdir,  # dir that you want dir on
                                # always start with slash plus user name, and end with slash plus dot
                                # examples:
                                #      /xmaspool/distribution/.
                                #      /xmaspool/../pooldata/shipping/.

    $paDir,           # return to caller: data lines only; filter out status lines for example; no CR/LF junk on end
                      # we expect tokens to be in certain locations as follows
                      #     0=permissions
                      #     1=?
                      #     2=user
                      #     3=group
                      #     4=size
                      #     5,6,7=stamp
                      #     8=fn
                      # example:
                      #    0             1 2        3                  4  5   6  7     8
                      #    '----------   1 owner    group              39 Apr 26 11:17 tedh.inf'
                      #    'd---------   1 owner    group               0 Jan 14  2000 cmo_cdi'

    $paErr,        # if error, push msg(s) here
    ) = @_;

my $func = 'GetRemoteDirViaLWP';
AppendLog ( "$func: start: subdir=$subdir" );
FixSlashes ( \$subdir, "unix" );
my @aTraceBack = ();

######################## all the following code is also in DownloadFileViaLWP() #############################

# build a User Agent object
my $ua = new LWP::UserAgent;
$ua->timeout(60);
$ua->agent( "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0)" );
my ($proxy_name,$proxy_user,$proxy_password ) = split(",",$hIniFile{'LWP'} );  # from ini file
AppendLog ( "$func(): proxy_name: $proxy_name" );
$ua->proxy ( ['ftp'], $proxy_name );

# build a Request object
my $user = $hIniFile{user};
my $password = $ftp_server_password;  # global
my $server = $hIniFile{connection};
$subdir = substr($subdir,1) if ( $subdir =~ /^\// );                    # chop leading slash
$subdir = substr($subdir,0,length($subdir)-1) if ( $subdir =~ /\.$/ );  # chop trailing dot
my $get = "ftp://$user:$password\@$server/$subdir";   # e.g. "ftp://uuuuu:ppppp@ftp.intex.com/uuuu/"
AppendLog ( "$func: get: $get" );
push ( @aTraceBack, "get=$get" );
my $req =new HTTP::Request ('GET', $get);

if ( defined ( $proxy_user ) )
    {
    AppendLog ( "$func(): call proxy_authorization_basic() method on request object; arg0=$proxy_user; arg1=$proxy_password" );
    $req->proxy_authorization_basic($proxy_user,$proxy_password);  # "uuuuu-com","ppppp"
    }

# make the request
AppendLog ( "$func(): call request() method" );
my($res) = $ua->request($req );

if (!defined($res))
    {
    # want user-friendly message(s), followed by traceback
    AppendLog ( "$func: ERROR: res is undefined after request() call was made" );
    my $err = "Unable to get dir listing from ship server";
    push (@$paErr, $err, "", "Traceback:", @aTraceBack );
    return;
    }

if ( !$res->is_success )
    {
    # want user-friendly message(s), followed by traceback
    AppendLog ( "$func: ERROR: is_success is false" );
    push ( @aTraceBack, $res->as_string() );
    my $err = "Unable to get file from ship server. Try to run this get command using your browser to manually diagnose the problem: $get";
    push (@$paErr, $err, "", "Traceback:", @aTraceBack );
    return;
    }

my @aRaw  =split(/\n/, $res->as_string());
AppendLog ( "$func: we have a response from ship server
We have parsed into into lines as follows:
==========================
" . join("\n",@aRaw) . "
==========================" );

# depending on your proxy server, uncomment one of the following lines:
## push ( @$paDir, XlatHtmlToDirListingVer1(\@aRaw) );
##push ( @$paDir, XlatHtmlToDirListingVer2(\@aRaw) );
##push ( @$paDir, XlatHtmlToDirListingVer3(\@aRaw) );
##push ( @$paDir, XlatHtmlToDirListingVer4(\@aRaw) );
push ( @$paDir, XlatHtmlToDirListingVer5(\@aRaw) );

return ();  # no errors

} # GetRemoteDirViaLWP


sub GetRemoteDirSecureFX
{
my (
    $subdir,  # dir that you want dir on
                  # always start with slash plus user name, and end with slash plus dot
                  # examples:
                  #      /xmaspool/distribution/.
                  #      /xmaspool/../pooldata/shipping/.

    $paDir,     # return to caller: data lines only; filter out status lines for example; no CR/LF junk on end
                            # we expect tokens to be in certain locations as follows
                            #     0=permissions
                            #     1=?
                            #     2=user
                            #     3=group
                            #     4=size
                            #     5,6,7=stamp
                            #     8=fn
                            # example:
                            #    0             1 2        3                  4  5   6  7     8
                            #    '----------   1 owner    group              39 Apr 26 11:17 tedh.inf'
                            #    'd---------   1 owner    group               0 Jan 14  2000 cmo_cdi'

    $paErr,        # if error, push msg(s) here
    ) = @_;

unlink($::szFtpOut);
AppendLog( "GetRemoteDirSecureFx(): start: subdir=$subdir" );
my $szUser = $hIniFile{'user'} ;
$subdir =~ s/[\\\/]$szUser[\\\/]// ;
$subdir = "" if ( $subdir eq "." ) ;

my @aTraceBack = ();

push ( @aTraceBack, "subdir=$subdir" );  # junky

# create ftp command file
my @aftpLines = ();

my $szCmd ;
if ( $hIniFile{'securefx_exe'} )
   {
   my $szSecureFxExe = $hIniFile{'securefx_exe'} ;
   $szCmd = "$com_spec $szSecureFxExe ftp:\/\/".$hIniFile{'user'}.":".$ftp_server_password."\@".$hIniFile{'connection'}."\/$subdir"."thisfiledoesnotexist_usedtogetdirlisting* ". $hIniFile{'temp_download_subdir'}." > $::szFtpOut" ;
   }
else
   {
   $szCmd = "$com_spec sfxcl.EXE ftp:\/\/".$hIniFile{'user'}.":".$ftp_server_password."\@".$hIniFile{'connection'}."\/$subdir"."thisfiledoesnotexist_usedtogetdirlisting* ". $hIniFile{'temp_download_subdir'}." > $::szFtpOut" ;
   }

AppendLog( "GetRemoteDirSecureFx(): start: $szCmd" );

system ( $szCmd ) ;

if ( ! open ( FTPOUT, $::szFtpOut ) )
   {
    AppendLog( "GetRemoteDirSecureFx(): could not open $::szFtpOut" );
    return ;
   }
@aFtpOutLine = <FTPOUT> ;
close ( FTPOUT );

chomp ( @aFtpOutLine );

# 2003-06-11 10:21:12, 00001: Transfer(00DEA9AC): 125 Data connection already open; Transfer starting.
#
# 2003-06-11 10:21:12, 00001: Transfer(00DEA9AC): -rwxrwxrwx   1 owner    group         1135927 Jun 10 16:44 cmo_cdi.001089.tar.Z
#
# 2003-06-11 10:21:12, 00001: Transfer(00DEA9AC): -rwxrwxrwx   1 owner    group       128505860 Jun 10 16:45 cmo_cdu.001089.tar.Z
#
# 2003-06-11 10:21:12, 00001: Transfer(00DEA9AC): -rwxrwxrwx   1 owner    group              30 Jun 10 16:46 eot.001089.txt
#
# 2003-06-11 10:21:12, 00001: Transfer(00DEA9AC): drwxrwxrwx   1 owner    group               0 Jun 10 16:46 last
#
# 2003-06-11 10:21:12, 00001: Transfer(00DEA9AC): drwxrwxrwx   1 owner    group               0 Jun 10 16:46 last2
#
# 2003-06-11 10:21:12, 00001: Transfer(00DEA9AC): drwxrwxrwx   1 owner    group               0 Jun 10 16:46 last3
#
# 2003-06-11 10:21:12, 00001: Transfer(00DEA9AC): drwxrwxrwx   1 owner    group               0 Jun 10 16:46 last4
#
# 2003-06-11 10:21:12, 00001: Transfer(00DEA9AC): drwxrwxrwx   1 owner    group               0 Jan  8  1:27 mini

my @aDirDataLine = ();   # build up info here
my $found_cd_code_250 = 0;

my @aListOfFiveCauses =
    (
     "1) Problem connecting from the autodnld machine to your firewall",
     "2) Firewall machine not allowing FTP access to Intex server",
     "3) Intex server not online",
     "4) Your IP address has changed",
     "5) Incorrect password provided to the ship server",
     "To test connection try manually ftp'ing to ship server",
     "Also see if any changes made to your firewall",
     );

##print "
## GetRemoteDirFtp(): aFtpOutLine:
##---------------------------- start
##" . join("\n",@aFtpOutLine) . "
##-------------------------- end\n";

foreach my $line (@aFtpOutLine) # global
    {
    chop ( $line ) ;
    next if ( $line =~ /^\s*$/ ) ;
    # if using ncftp, just pattern match on owner...group
    if ( $line =~ /^.*owner\s+group.*distrib|^.*owner\s+group.* last|^.*owner\s+group.* 2[01]\d\d *$/ )
        {
        AppendLog ( "GetRemoteDirSecureFX: line found to be a dir== $line" );
        $line =~ s/^.*(owner\s+group)/d-----  1  $1/i ;
        push ( @$paDir, $line );
        }
    elsif ( $line =~ /owner\s+group/ )
        {
        AppendLog ( "GetRemoteDirSecureFX: line found but not a dir== $line" );
        $line =~ s/^.*(owner\s+group)/-----  1  $1/i ;
        push ( @$paDir, $line );
        }
    else
        {
        AppendLog ( "GetRemoteDirSecureFX: line NOT found== $line" );
        }
    }

AppendLog ( "GetRemoteDirSecureFX: found lines:\n" . join ("\n", @$paDir )  );

return ();

} # GetRemoteDirSecureFX



# ------------------------- GetRemoteDir
# get remote dir; see worker routines for explanation of parameters
sub GetRemoteDir
{
my (
    $subdir,
    $paRemoteDirArray,   # fill in data lines
    $paErr,              # if have errors, push lines here
    $bFilesNotNeeded,
    ) = @_;

my $func = "GetRemoteDir";

if ( $subdir =~ /\w\/$/ )
    {
    $subdir .= ".";
    AppendLog ( " $func: fixed path by adding dot; new val=$subdir" );
    }
elsif ( $subdir =~ /\w$/ )
    {
    $subdir .= "/.";
    AppendLog ( " $func: fixed path by adding slash dot; new val=$subdir" );
    }

if(defined $hIniFile{'https'} && $hIniFile{'https'}==1)
      {
         DownloadDIRViaHTTP($subdir, $paRemoteDirArray, $paErr,$bFilesNotNeeded );
         return;
      }

elsif ( defined ( $hIniFile{pasv_ftp} ) )
    {
    GetRemoteDirPasvFtp($subdir, $paRemoteDirArray, $paErr, $bFilesNotNeeded );
    return;
    }
elsif ( uc( $hIniFile{securefx} ) eq "Y" )
    {
    GetRemoteDirSecureFX($subdir, $paRemoteDirArray, $paErr, $bFilesNotNeeded );
    return;
    }
elsif ( defined ( $hIniFile{'LWP'} ) )
    {
    GetRemoteDirViaLWP($subdir, $paRemoteDirArray, $paErr, $bFilesNotNeeded );
    return;
    }
# ftp?
else
    {
    GetRemoteDirFtp($subdir, $paRemoteDirArray, $paErr, $bFilesNotNeeded );
    return;
    }

} # GetRemoteDir

# ------------------------- MoveEotFile
# get remote dir; see worker routines for explanation of parameters
sub MoveEotFile
{
my (
    $szSourceFile,
    $szDestFile,
    $szIdPath,
    $paMoveEotArray,   # fill in data lines
    $paErr,              # if have errors, push lines here
    ) = @_;

my $func = "MoveEotFile ";

if ( defined ( $hIniFile{pasv_ftp} ) )
    {
    MoveEotPassiveFtp ( $szSourceFile, $szIdPath . $szDestFile, $paMoveEotArray, $paErr );
    return;
    }
elsif ( uc( $hIniFile{securefx} ) eq "Y" )
    {  
    MoveEotSecureFX ( $szSourceFile, $szDestFile, $paMoveEotArray, $paErr );
    return;
    }
elsif ( defined ( $hIniFile{'LWP'} ) )
    {
   # MoveEotViaLWP($subdir, $paRemoteDirArray, $paErr, $bFilesNotNeeded );
    return;
    }
# ftp?
else
    {
    MoveEotFtp( $szSourceFile, $szIdPath .$szDestFile, $paMoveEotArray, $paErr );
    return;
    }

} # GetRemoteDir


# ----------- VerifyRemoteDir
# if using HTTP, cannot always detect request that fails ... may get HTML erors from proxy server
# return non zero if error
sub VerifyRemoteDir
{
   my (
       $szDistribPrefix,
       @aLine
       ) = @_;

   my ( $szLine, @aToken );

   foreach $szLine ( @aLine )
   {
      @aToken = split(/ +/,$szLine);

      if ( $szLine =~ /^d/ && defined($aToken[8]) && $aToken[8] =~ /^$szDistribPrefix/ )
      {
         return 0;
      }
   }

   return 1;

 } # VerifyRemoteDir


1;
