use strict;
use IPC::Open3;
use vars ( qw ( %hCrntEnv $slash));

sub MakeRequestViaCurlAndWrapError {
    my ($phRequest, $bVerbose, $sCurlCommand, $fAppendLog) = @_;

    my $bSucceeded = 0;
    my ($sErrorMessage, $sFn);
    eval {
        $sFn = MakeRequestViaCurl($phRequest, $bVerbose, $sCurlCommand, $fAppendLog);
        $sErrorMessage = '';
        $bSucceeded = 1;
    };
    if (!$bSucceeded) {
        $sErrorMessage = $@;
    }
    return ($sErrorMessage, $sFn, 1);
}

sub MakeRequestViaCurl {
    my ($phRequest, $bVerbose, $sCurlCommand, $fAppendLog) = @_;

    my $sPostData = $phRequest->{'sBody'};
    my $sOutputFn = $phRequest->{'sOutputFn'} || die "Missing output file for request";

    my $sHost        = $phRequest->{'sHost'};
    my $port         = $phRequest->{'iPort'};
    my $sPath        = $phRequest->{'sPath'};
    my $sMethod      = $phRequest->{'sMethod'} || 'POST';
    my $paHeaders    = $phRequest->{'paHeaders'} || [];

    my $sUrl = "https://$sHost:$port$sPath";

    my $sPostDataFn   = "$hCrntEnv{tgt_log_dir}${slash}post_data.txt";
    my $sCurlOutputFn = "$hCrntEnv{tgt_log_dir}${slash}curl_stderr.txt";

    # Save the post data to the input file
    open(my $fh, '>', $sPostDataFn) or die "Failed to open CURL input file, $sPostDataFn, $!";
    binmode($fh);
    print $fh $sPostData;
    close($fh);

    my $sFullCurlCommand = $sCurlCommand." -X $sMethod --silent -S --data-binary \"\@$sPostDataFn\" -o \"$sOutputFn\" -i $sUrl";

    if (my $sProxyHost = $ENV{'HTTPS_PROXY'}) {
        my $sProtocol = 'http';
        if ($sProxyHost =~ m@(https?)://(.*)@i) {
            ($sProtocol, $sProxyHost) = ($1, $2);
        }
        my $sProxyUrl = "$sProtocol://";
        if (my $sProxyUser = $ENV{'HTTPS_PROXY_USERNAME'}) {
            $sProxyUrl .= "$sProxyUser:$ENV{HTTPS_PROXY_PASSWORD}\@";
        }
        $sProxyUrl .= $sProxyHost;
        $sFullCurlCommand .= " --proxy $sProxyUrl";
    }

    if (my $sCaCert = $ENV{'HTTPS_CA_FILE'}) {
        $sFullCurlCommand .= " --cacert \"$sCaCert\"";
    }

    if (my $sCaDir = $ENV{'HTTPS_CA_DIR'}) {
        $sFullCurlCommand .= " --capath \"$sCaDir\"";
    }
    elsif (my $sCaPath = $ENV{'HTTPS_CA_PATH'}) {
        $sFullCurlCommand .= " --capath \"$sCaPath\"";
    }

    if (my $sCert = $ENV{'HTTPS_CERT_FILE'}) {
        $sFullCurlCommand .= " --cert \"$sCert\"";
    }

    if (my $sKey = $ENV{'HTTPS_KEY_FILE'}) {
        $sFullCurlCommand .= " --key \"$sKey\"";
    }

    if (my $sVerifyMode = $ENV{'HTTPS_VERIFY_MODE'}) {
        if ($sVerifyMode =~ m/none/i) {
            $sFullCurlCommand .= " --insecure";
        }
    }

    if (my $sVerifyMode = $ENV{'HTTPS_VERSION'}) {
        die "The HTTPS_VERSION option is not compatible with the Curl backend";
    }

    foreach my $paHeader (@$paHeaders) {
        my ($sHeaderName, $sHeaderValue) = @$paHeader;
        next if $sHeaderName =~ m/^content-length$/i;
        $sFullCurlCommand .= " -H \"$sHeaderName: $sHeaderValue\""
    }

    if ($bVerbose) {
        $fAppendLog->("Curl Command: $sFullCurlCommand");
    }

    my $iRetVal = system("$sFullCurlCommand > \"$sCurlOutputFn\" 2>&1");
    if ($iRetVal != 0) {
        my $sCurlOutput = '';
        if (open(my $fh, '<', $sCurlOutputFn)) {
            local $/ = undef;
            $sCurlOutput = <$fh>;
            close($fh);
        }
        die "Got non-zero exit code while running CURL command, $?.  $!. Curl command=$sFullCurlCommand.  Curl output=$sCurlOutput";
    }

    return $sOutputFn;
}

1;
